#ifndef ISIMENTITY_H_
#define ISIMENTITY_H_

#include <list>
#include <string>
#include "../Configuration/ConfigurationServer.h"
#include "../PhysicsEngine/IPhysicsController.h"
#include "../PhysicsEngine/PhysicsControllerFactory.h" 
#include "ICommand.h"
using namespace PhysicsEngine;
using namespace Configuration;
using namespace std;
namespace SimulationEngine
{

class ISimEntity
{
public:
	ISimEntity();
	ISimEntity(int entityid);
	virtual ~ISimEntity();
	ICommand *GetCommand(string commandkey);
	virtual string GetSimString()=0;
	virtual string PersistEntity()=0;
	void AddCommand(ICommand *cmd);
	int GetEntityId();
	virtual void SetEntityPosition(float posx, float posy, float posz)=0;
	
private:
	list <ICommand *> commands;
	int entityid;
	
};

}

#endif /*ISIMENTITY_H_*/
